let tasks = [];
let idCounter = 1;

module.exports = {
  // GET all tasks
  getAllTasks: (req, res) => {
    res.json(tasks);
  },

  // CREATE new task
  createTask: (req, res) => {
    const { title, description, dueDate, status } = req.body;

    if (!title || !description) {
      return res.status(400).json({ message: "Title and description are required." });
    }

    const newTask = {
      id: idCounter++,
      title,
      description,
      status: status || "pending",
      dueDate: dueDate || null,
    };

    tasks.push(newTask);
    res.json({ message: "Task created successfully!", task: newTask });
  },

  // GET task by ID
  getTaskById: (req, res) => {
    const id = parseInt(req.params.id);
    const task = tasks.find((t) => t.id === id);

    if (!task) return res.status(404).json({ message: "Task not found" });

    res.json(task);
  },

  // UPDATE task
  updateTask: (req, res) => {
    const id = parseInt(req.params.id);
    const task = tasks.find((t) => t.id === id);

    if (!task) return res.status(404).json({ message: "Task not found" });

    const { title, description, status, dueDate } = req.body;

    if (!title || !description) {
      return res.status(400).json({ message: "Title and description cannot be empty." });
    }

    task.title = title;
    task.description = description;
    task.status = status;
    task.dueDate = dueDate;

    res.json({ message: "Task updated successfully!", task });
  },

  // DELETE task
  deleteTask: (req, res) => {
    const id = parseInt(req.params.id);
    const index = tasks.findIndex((t) => t.id === id);

    if (index === -1) return res.status(404).json({ message: "Task not found" });

    tasks.splice(index, 1);
    res.json({ message: "Task deleted successfully" });
  },
};
